import { Box, Mail, Phone, MapPin, Clock, Github, Linkedin, Twitter } from 'lucide-react'
import './Footer.css'

function Footer() {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <div className="footer-logo-icon-wrapper">
                <Box size={32} strokeWidth={2.5} className="footer-logo-icon" />
                <div className="footer-logo-glow"></div>
              </div>
              <h2 className="footer-logo-text">Model3D</h2>
            </div>
            <p className="footer-description">
              Профессиональные онлайн-курсы по 3D-моделированию. 
              Освойте Blender, Maya, 3ds Max и ZBrush с нуля до профи.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link">
                <Github size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Linkedin size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Twitter size={20} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Навигация</h3>
            <ul className="footer-links">
              <li><a href="/">Мои проекты</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">Программы</a></li>
              <li><a href="#">Преподаватели</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={16} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} strokeWidth={2} />
                <a href="mailto:info@model3d.ru">info@model3d.ru</a>
              </li>
              <li>
                <MapPin size={16} strokeWidth={2} />
                <span>Москва, ул. 3D-Авеню, 15</span>
              </li>
              <li>
                <Clock size={16} strokeWidth={2} />
                <span>Пн-Вс: 09:00 - 21:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 Model3D. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

